using System;

class Pierwiastek
{
  public static double pobierzLiczbe(string param)
  {
    double liczba = 0;
    bool sukces;
    do
    {
      Console.Write("Prosz poda {0} parametr rwnania: ", param);
      try
      {
        liczba = Double.Parse(Console.ReadLine());
        sukces = true;
      }
      catch(Exception)
      {
        Console.WriteLine(
          "To nie jest prawidowa liczba rzeczywista!");
        sukces = false;
      }
    }
    while(!sukces);
    return liczba;
  }
  public static void Main(string[] args)
  {
    bool liniaKomend = true;
    double parametrA = 0, parametrB = 0, parametrC = 0;

    if(args.Length < 3)
    {
      liniaKomend = false;
    }
    if(liniaKomend)
    {
      try
      {
        parametrA = Double.Parse(args[0]);
        parametrB = Double.Parse(args[1]);
        parametrC = Double.Parse(args[2]);
      }
      catch(Exception)
      {
        Console.WriteLine("Jeden z wprowadzonych parametrw nie jest poprawn liczb!");
        liniaKomend = false;;
      }
    }

    if(!liniaKomend)
    {
      parametrA = pobierzLiczbe("pierwszy");
      parametrB = pobierzLiczbe("drugi");
      parametrC = pobierzLiczbe("trzeci");
    }

    Console.WriteLine("Wprowadzone parametry rwnania:\n");
    Console.WriteLine("A = " + parametrA + ", B = " + parametrB + 
                      ", C = " + parametrC + "\n");

    if (parametrA == 0)
    {
      Console.WriteLine("To nie jest rwnanie kwadratowe: A = 0!");
    }
    else
    {
      double delta = parametrB * parametrB - 4 * parametrA * parametrC;
      double wynik;

      if (delta < 0)
      {
        Console.WriteLine("Delta < 0");
        Console.WriteLine(
          "Brak rozwiza w zbiorze liczb rzeczywistych.");
      }
      else if (delta == 0)
      {
        wynik = - parametrB / 2 * parametrA;
        Console.WriteLine("Rozwizanie: x = " + wynik);
      }
      else
      {
        wynik = (-parametrB + Math.Sqrt(delta)) / (2 * parametrA);
        Console.Write("Rozwizanie: x1 = " + wynik);
        wynik = (-parametrB - Math.Sqrt(delta)) / (2 * parametrA);
        Console.WriteLine(", x2 = " + wynik);
      }
    }
  }
}
